/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render.overlay;

import club.sk1er.patcher.config.PatcherConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ArmorStatusRenderer {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onRenderArmor(GuiScreenEvent.DrawScreenEvent.Post event) {
        GuiScreen gui = event.getGui();
        if ((PatcherConfig.protectionPercentage || PatcherConfig.projectileProtectionPercentage) && (gui instanceof GuiInventory || gui instanceof GuiContainerCreative)) {
            String armorValue = this.getArmorString();
            if (armorValue == null) {
                return;
            }
            ScaledResolution res = new ScaledResolution(this.mc);
            this.mc.field_71466_p.func_175065_a(armorValue, 10.0f, (float)(res.func_78328_b() - 16), -1, true);
        }
    }

    private String getArmorString() {
        double protectionPotential = this.roundDecimals(this.getArmorPotential(false));
        double projectileProtectionPotential = this.roundDecimals(this.getArmorPotential(true));
        if (protectionPotential == 0.0 && projectileProtectionPotential == 0.0) {
            return null;
        }
        if (!PatcherConfig.protectionPercentage || !PatcherConfig.projectileProtectionPercentage) {
            if (PatcherConfig.protectionPercentage) {
                return protectionPotential + "%";
            }
            if (PatcherConfig.projectileProtectionPercentage) {
                return projectileProtectionPotential + "%";
            }
            return null;
        }
        if (protectionPotential == projectileProtectionPotential) {
            return protectionPotential + "%";
        }
        return protectionPotential + "% | " + projectileProtectionPotential + "%";
    }

    private double roundDecimals(double num) {
        if (num == 0.0) {
            return num;
        }
        num = (int)(num * Math.pow(10.0, 2.0));
        return num /= Math.pow(10.0, 2.0);
    }

    private double getArmorPotential(boolean getProj) {
        double armor = 0.0;
        int epf = 0;
        int resistance = 0;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (player.func_70644_a(MobEffects.field_76429_m)) {
            resistance = player.func_70660_b(MobEffects.field_76429_m).func_76458_c() + 1;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof ItemArmor) {
                ItemArmor armorItem = (ItemArmor)stack.func_77973_b();
                armor += (double)armorItem.field_77879_b * 0.04;
            }
            if (stack.func_77948_v()) {
                epf += this.getEffProtPoints(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180310_c, (ItemStack)stack));
            }
            if (!getProj || !stack.func_77948_v()) continue;
            epf += this.getEffProtPoints(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180308_g, (ItemStack)stack));
        }
        epf = Math.min(epf, 25);
        double avgDef = this.addArmorProtResistance(armor, this.calcProtection(epf), resistance);
        return this.roundDouble(avgDef * 100.0);
    }

    private int getEffProtPoints(int level) {
        if (level != 0) {
            return (int)Math.floor((double)(6 + level * level) * 0.75 / 3.0);
        }
        return 0;
    }

    private double calcProtection(int armorEpf) {
        double protection = 0.0;
        for (int i = 50; i <= 100; ++i) {
            double min = Math.min(Math.ceil((double)(armorEpf * i) / 100.0), 20.0);
            protection += min;
        }
        return protection / 51.0;
    }

    private double addArmorProtResistance(double armor, double prot, int resistance) {
        double protTotal = armor + (1.0 - armor) * prot * 0.04;
        protTotal += (1.0 - protTotal) * (double)resistance * 0.2;
        return Math.min(protTotal, 1.0);
    }

    private double roundDouble(double number) {
        double x = Math.round(number * 10000.0);
        return x / 10000.0;
    }
}

